#!/bin/bash
#
# Gregory Whitlock
#Ask for Client Name
#Client name
echo Please use single word, no spaces, lowercase, for clientname ex. client1

echo
read -p "What is the name of your client?: "  -e CLIENT

#Ask for WAN IP
echo "Enter WAN IP in x.x.x.x format ex. 166.166.166.166"
echo
read -p "What is the WAN IP for your OpenVPN server: " -e WANIP

#Push routes?
echo "Enter Route in x.x.x.x x.x.x.x format, ex. 192.168.1.0 255.255.255.248"
echo
read -p "Does your client have routes to push? [y/n]: " -e ROUTES
if [[ "$ROUTES" = "y" || "$ROUTES" = "Y" ]] ;

then

echo
read -p "Enter IP Address and subnet mask for Push Routes: " -e ROUTE

if [ -e /etc/openvpn/server/server.conf ]; then
    echo "server conf exists (I'd hope so!)"
fi
if !  grep -q "client-conf-dir" /etc/openvpn/server/server.conf 
then
    echo "client-conf-dir does NOT exist in my server.conf. I should add it"
    echo "client-config-dir /var/ccd " >> /etc/openvpn/server/server.conf
else
	echo "client-config-dir /var/ccd exists in server.conf"
fi

if [ -e /etc/openvpn/server/server.conf ]; then
    echo "server conf exists (I'd hope so!)"
fi
if !  grep -q "push \"route $ROUTE\"" /etc/openvpn/server/server.conf 
then
    echo "push \"route $ROUTE\" does NOT exist in my server.conf. I should add it"
    echo "push \"route $ROUTE\" " >> /etc/openvpn/server/server.conf
else
	echo "push \"route $ROUTE\" exists in server.conf"
fi

if [ -e /etc/openvpn/server/server.conf ]; then
    echo "server conf exists (I'd hope so!)"
fi
if !  grep -q "route $ROUTE " /etc/openvpn/server/server.conf 
then
    echo "route $ROUTE does NOT exist in my server.conf. I should add it"
    echo "route $ROUTE" >> /etc/openvpn/server/server.conf
else
	echo "route $ROUTE exists in server.conf"
fi
#Create CCD File
if [ -e /var/ccd/$CLIENT ]; then
    echo "$CLIENT ccd file exists (I'd hope so!)"

else
	touch /var/ccd/$CLIENT
        echo iroute $ROUTE >> /var/ccd/$CLIENT
	
fi
else
	echo "Done"
fi
#Create Client
cd /etc/openvpn/easy-rsa
EASYRSA_CERT_EXPIRE=3650 ./easyrsa build-client-full $CLIENT nopass
mkdir ~/clients
mkdir ~/clients/$CLIENT
cp /etc/openvpn/easy-rsa/pki/ca.crt ~/clients/$CLIENT
cp /etc/openvpn/easy-rsa/pki/ta.key ~/clients/$CLIENT
cp /etc/openvpn/easy-rsa/pki/private/$CLIENT.key ~/clients/$CLIENT
cp /etc/openvpn/easy-rsa/pki/issued/$CLIENT.crt ~/clients/$CLIENT

#Create .conf File
echo client >> ~/clients/$CLIENT/$CLIENT.conf
echo dev tun >> ~/clients/$CLIENT/$CLIENT.conf
echo proto udp >> ~/clients/$CLIENT/$CLIENT.conf
echo remote $WANIP 1194 >> ~/clients/$CLIENT/$CLIENT.conf
echo nobind >> ~/clients/$CLIENT/$CLIENT.conf
echo persist-tun >> ~/clients/$CLIENT/$CLIENT.conf
echo ca ca.crt >> ~/clients/$CLIENT/$CLIENT.conf
echo cert $CLIENT.crt >> ~/clients/$CLIENT/$CLIENT.conf
echo key $CLIENT.key >> ~/clients/$CLIENT/$CLIENT.conf
echo remote-cert-tls server >> ~/clients/$CLIENT/$CLIENT.conf
echo tls-auth ta.key 1 >> ~/clients/$CLIENT/$CLIENT.conf
echo cipher AES-256-CBC >> ~/clients/$CLIENT/$CLIENT.conf
echo verb 3 >> ~/clients/$CLIENT/$CLIENT.conf

#Restart Openvpn Server
systemctl restart openvpn-server@server.service
