#!/bin/bash
 

if [ ! -e "/etc/version" ]; then
 echo "Unit does not appear to be a JBM unit, exiting."
 exit 1
fi

#ZIP file archive must be called:
FILE_NAME=$1
 
if [ ! -e "$FILE_NAME" ]; then
 echo "Canot find package file $FILE_NAME"
 exit 1
fi

echo "Setting up files ... PLEASE WAIT ..." 
unzip -o $FILE_NAME -x install.sh -d /

##Stopping OpenVPN
echo "Stopping OpenVPN"
chkconfig openvpn off
service openvpn stop

##Removing any previous Files
echo "Removing Any previously installed OpenVPN Files"
rm -f /etc/openvpn/*.key
rm -f /etc/openvpn/*.crt
rm -f /etc/openvpn/*.conf
rm -f /etc/redlion/certificates/*.key
rm -f /etc/redlion/certificates/*.crt

sleep 30

##Moving Files from /tmp/ to /etc/openvpn
echo "Moving Files"
cd /tmp/files/

mv *.key /etc/openvpn/
mv *.crt /etc/openvpn/
mv *.conf /etc/openvpn/

##Starting OpenVPN
echo "Starting OpenVPN"
chkconfig openvpn on
service openvpn start


rm -f $FILE_NAME
echo " ============================================= "
echo "            Installation complete."
echo " ============================================= "
echo
 
