#!/bin/bash
#
# Template for install.sh

#Do not change
SCRIPT_VERSION="2.05"

#######################################
#######################################
#
# Main install() function to be
# modified for custom installs.
# This scriptcan only be run on builds
# 3.16/4.16 and higher
#
#######################################
#######################################
install()
{

    #Unzip everything to / but install.sh
    unzip_file "$1"

    # Update patch install.sh
    echo "Updating GAU access page."
    cp -f -v gauaccess.html /home/httpd/jbmconfig/html/pages/
    echo "Updating GAU access profile."
    cp -f -v gauaccess.prf /home/httpd/jbmconfig/conf/
    echo "Removing non-admin users."
    grep admin /etc/iog/htdigest > /tmp/htdigest.tmp ; cp /tmp/htdigest.tmp /etc/iog/htdigest -f
    exit 0

} #end of install(), do not remove


# Check user to make sure this script runs as admin
#
check_user()
{
    echo "Checking user. $(id)"
    if [ "$(whoami)" != "admin" ]; then
        echo "Script must be run as user: admin"
        exit 255
    fi
}

#Unzip everything to /tmp but install.sh
#
# Return 0 on success
# Return 1 on error
#
unzip_file()
{
    echo "Extracting patch files."
    local RETURN=0
    #ZIP file archive must be called:
    local FILE_NAME=$1

    if [ ! -e "$FILE_NAME" ]; then
        echo "Cannot find package file $FILE_NAME"
        exit 1
    fi

    #unzip everything but the script and special dirs
    unzip -o $FILE_NAME -x "install.sh" -d /tmp

    if [ $? != 0 ]; then
        RETURN=1
    fi

    return $RETURN
}

echo "Installing patch."
install "$@"
exit 0
